using ComponentPro;

namespace AdvancedDemo.Samples.Function_and_Property
{
    class Author
    {
        public string Name
        {
            get
            {
                return "John Borders";
            }
        }
    }

    class Book
    {
        public static string StaticId
        {
            get
            {
                return "AABB";
            }
        }
        public int BookId
        {
            get
            {
                return 100;
            }
        }
        public Author Author
        {
            get
            {
                return new Author();
            }
        }
    }

    class Object_Property : TemplateExampleBase
    {
        /// <summary>
        /// Generates output from a template file.
        /// </summary>
        /// <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
        /// <param name="templateFile">The template file path.</param>
        /// <param name="templateSource">The template source loaded from the template file.</param>
        /// <returns>The generated output.</returns>
        public override string Generate(string templateSourceDirectory, string templateFile, string templateSource)
        {
            // Create a new instance of the TemplateEngine class.
            TemplateEngine dt = new TemplateEngine();

            // Load template content from a file.
            dt.LoadFromString(templateSource);
            dt.SetValue("TemplateSourceDirectory", templateSourceDirectory);

            Book mybook = new Book();
            dt.SetValue("bk", mybook);

            dt.UsingNamespace("AdvancedDemo.Samples.Function_and_Property,AdvancedDemo");

            // Generate output.
            string output = dt.Run();

            return output;
        }
    }
}
